<?php
session_start();
include('db.php');

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user is logged in
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.',
        'cart_count' => 0,
        'totalamount' => 0
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']);

// Query to get cart count and total amount for the user
$query = "SELECT 
            COUNT(*) as cart_count, 
            SUM(p.Selling_price * c.Quantity) as total_amount
          FROM cart c
          JOIN product p ON c.Product_id = p.Product_id
          WHERE c.User_id = $user_id AND c.Delete_status = 0";
$result = mysqli_query($conn, $query);

if (!$result) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . mysqli_error($conn),
        'cart_count' => 0,
        'totalamount' => 0
    ]);
    exit;
}

$row = mysqli_fetch_assoc($result);
$cart_count = $row['cart_count'] ?? 0;
$total_amount = $row['total_amount'] ?? 0;

echo json_encode([
    'status' => 'success',
    'cart_count' => (int)$cart_count,
    'totalamount' => (float)$total_amount
]);

mysqli_close($conn);
?>